
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SHARE_FOLDER');

SET @msgTemplateConfigId=(SELECT id FROM msg_template_config WHERE `code`='Share Folder' and sysMsgEventId = @sysMsgEventId );
INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES (@msgTemplateConfigId, '6', NULL, 'A file has been shared on the Academia Drive');


-- adhoc message sent 
SET @parent=(SELECT id FROM dtprovider WHERE `dataProviderName`='PARENT_RECIPIENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
   -- T3.`mobileNumber` AS MOBILE_NO,
    (case when ((T3.isMobUseForCommunication = false or T3.isMobUseForCommunication is null) and T3.isAlternateMobUseForCommunication = true) then T3.`alternateMobileNo`
     when ((T3.isMobUseForCommunication = false or T3.isMobUseForCommunication is null) and (T3.isAlternateMobUseForCommunication = false or T3.isAlternateMobUseForCommunication is null)) then NULL
    else T3.`mobileNumber`
    end) AS MOBILE_NO,
    -- T3.mobileCountryCode AS MOBILE_CODE,
    (case when ((T3.isMobUseForCommunication = false or T3.isMobUseForCommunication is null) and T3.isAlternateMobUseForCommunication = true) then T3.`alternateMobileCountryCode`
     when ((T3.isMobUseForCommunication = false  or T3.isMobUseForCommunication is null) and (T3.isAlternateMobUseForCommunication = false  or T3.isAlternateMobUseForCommunication is null)) then NULL
    else T3.`mobileCountryCode`
    end) AS MOBILE_CODE,
     GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
  
FROM   
    `persons` T3 
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
     LEFT JOIN
    `parents` pt ON pt.personId = T3.id
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = pt.userId
    
WHERE
    T3.id IN (namedParams)
    AND (T3.isDeceased is NUll OR T3.isDeceased=false)" WHERE `dataProviderId`=@parent; 
   
    
    -- Academia Drive
    
SET @academiaDrive=(SELECT id FROM dtprovider WHERE `dataProviderName`='SHARE_FOLDER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    students AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
     LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T3.id
WHERE
    T1.id IN (namedParams) group by T1.id
UNION SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    staffs AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
     LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T3.id
WHERE
    T1.id IN (namedParams) group by T1.id
UNION SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    parents AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
     LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T3.id
WHERE
    T1.id IN (namedParams) group by T1.id" WHERE `dataProviderId`=@academiaDrive; 
    

